<?php
include 'db.php';
session_start(); // Oturum başlat

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $ad = $_POST['ad'];
    $soyad = $_POST['soyad'];
    $tc_no = $_POST['tc_no'];
    $sifre = password_hash($_POST['sifre'], PASSWORD_BCRYPT); // Şifreyi güvenli şekilde sakla
    $etiket = ""; // Etiket boş bırakılıyor
    $isletme_id = $_POST['isletme_id'];
    
    // personel_statusu'nu buraya ekliyoruz. Bu sadece bu formdan eklenenler için 1 olacak.
    $personel_statusu = 1;

    // Sayfa yenilenince tekrar kayıt olmaması için kontrol
    if (isset($_SESSION['last_tc']) && $_SESSION['last_tc'] == $tc_no) {
        $error = "Bu TC Kimlik Numarası zaten eklenmiş, tekrar kayıt yapamazsınız!";
    } else {
        // TC Kimlik No kayıtlı mı kontrol et
        $check_sql = "SELECT id FROM personeller WHERE personel_numara = ?";  // personeller tablosunda kontrol yap
        $check_stmt = $conn->prepare($check_sql);
        $check_stmt->bind_param("s", $tc_no);
        $check_stmt->execute();
        $check_stmt->store_result();

        if ($check_stmt->num_rows > 0) {
            $error = "Bu TC Kimlik Numarası zaten kayıtlı!";
        } else {
            // Yeni personel kaydını ekle ve personel_statusu'nu 1 olarak ayarla
            $sql = "INSERT INTO personeller (isletme_id, personel_ad, personel_soyad, personel_numara, personel_mail, personel_sifre, etiket, personel_statusu) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("sssssssi", $isletme_id, $ad, $soyad, $tc_no, $_POST['mail'], $sifre, $etiket, $personel_statusu);

            if ($stmt->execute()) {
                $_SESSION['last_tc'] = $tc_no; // Tekrar eklenmesini engelle
                echo "Personel başarıyla eklendi. Fatura bilgilerini girmek için yönlendiriliyorsunuz...";
                header("Location: fatura_bilgi.php?isletme_id=$isletme_id"); // Fatura bilgileri sayfasına yönlendir
                exit();
            } else {
                $error = "Kayıt eklenirken hata oluştu: " . $stmt->error;
            }
        }
    }
}

$isletme_id = $_GET['isletme_id'] ?? 0;
?>

<form method="POST">
    <input type="hidden" name="isletme_id" value="<?= $isletme_id ?>">
    Ad: <input type="text" name="ad" required><br>
    Soyad: <input type="text" name="soyad" required><br>
    TC Kimlik No: <input type="text" name="tc_no" required><br>
    E-posta: <input type="email" name="mail" required><br>
    Şifre: <input type="password" name="sifre" required><br>
    <button type="submit">Kaydet</button>
</form>

<?php
if (isset($error)) {
    echo "<p style='color: red;'>$error</p>";
}
