<?php
include 'db.php';
session_start(); // Oturum başlat

// Kullanıcı giriş yaptı mı kontrol et
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $mail = $_POST['mail'];
    $sifre = $_POST['sifre'];

    // E-posta ve şifreyi veritabanında kontrol et
    $sql = "SELECT id, personel_statusu, personel_sifre, isletme_id FROM personeller WHERE personel_mail = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $mail);
    $stmt->execute();
    $stmt->store_result();
    
    // Kullanıcı varsa
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $personel_statusu, $hash_sifre, $isletme_id);
        $stmt->fetch();
        
        // Şifreyi kontrol et
        if (password_verify($sifre, $hash_sifre)) {
            $_SESSION['user_id'] = $id; // Kullanıcı ID'sini oturuma ekle
            $_SESSION['personel_statusu'] = $personel_statusu; // Kullanıcı durumunu oturuma ekle
            $_SESSION['isletme_id'] = $isletme_id; // İşletme ID'sini oturuma ekle

            // personel_statusu'na göre yönlendirme yap
            if ($personel_statusu == 1) {
                // Admin paneline yönlendir
                header("Location: panel.php");
                exit();
            } elseif ($personel_statusu == 2) {
                // Personel paneline yönlendir
                header("Location: personel_panel.php");
                exit();
            }
        } else {
            $error = "Şifre hatalı!";
        }
    } else {
        $error = "Kullanıcı bulunamadı!";
    }
}
?>

<!-- Giriş formu -->
<form method="POST">
    E-posta: <input type="email" name="mail" required><br>
    Şifre: <input type="password" name="sifre" required><br>
    <button type="submit">Giriş Yap</button>
</form>

<?php
// Hata mesajı varsa göster
if (isset($error)) {
    echo "<p style='color: red;'>$error</p>";
}
?>
