<?php
include 'db.php';

$kategori_adlari = [
    1 => "Hamur İşi",
    2 => "Kahvaltılık",
    3 => "Et Yemekleri",
    4 => "Mangal",
    5 => "Vegan",
    6 => "Salata",
    7 => "Çorba"
];

$result = $conn->query("SELECT * FROM yemek_tarif ORDER BY id DESC");

?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yemek Tarifleri</title>
</head>
<body>
    <h2>Yemek Tarifleri</h2>
    <table border="1">
        <tr>
            <th>ID</th>
            <th>Kategori</th>
            <th>Yemek Adı</th>
            <th>Görsel</th>
            <th>Video</th>
        </tr>

        <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td><?= $kategori_adlari[$row['kategori_id']] ?></td>
            <td><?= $row['yemek_adi'] ?></td>
            <td>
                <?php if (!empty($row['resim'])): ?>
                    <img src="<?= $row['resim'] ?>" width="100">
                <?php else: ?>
                    Görsel Yok
                <?php endif; ?>
            </td>
            <td>
                <?php if (!empty($row['video_url'])): ?>
                    <a href="<?= $row['video_url'] ?>" target="_blank">İzle</a>
                <?php else: ?>
                    Video Yok
                <?php endif; ?>
            </td>
        </tr>
        <?php endwhile; ?>
    </table>
</body>
</html>
