<?php
include 'db.php'; // Veritabanı bağlantısını içeren dosya

session_start(); // Oturum başlat

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $sirket_adi = $_POST['sirket_adi'];
    $sirket_unvani = $_POST['sirket_unvani'];
    $adres = $_POST['adres'];
    $ilce = $_POST['ilce'];
    $il = $_POST['il'];
    $vergi_tc_no = $_POST['vergi_tc_no'];
    $vergi_dairesi = $_POST['vergi_dairesi'];

    // Sayfa yenilenince tekrar kayıt olmaması için kontrol
    if (isset($_SESSION['last_vergi_tc']) && $_SESSION['last_vergi_tc'] == $vergi_tc_no) {
        $error = "Bu TC Kimlik veya Vergi Numarası zaten eklenmiş, tekrar kayıt yapamazsınız!";
    } else {
        // TC veya Vergi No'nun aktif ya da silinmiş olup olmadığını kontrol et
        $check_sql = "SELECT id FROM isletmeler WHERE vergi_tc_no = ? AND (deleted_at IS NULL OR deleted_at != '')";
        $check_stmt = $conn->prepare($check_sql);
        $check_stmt->bind_param("s", $vergi_tc_no);
        $check_stmt->execute();
        $check_stmt->store_result();

        if ($check_stmt->num_rows > 0) {
            // Eğer aktif kayıt varsa hata ver
            $error = "Bu TC Kimlik veya Vergi Numarası zaten kayıtlı!";
        } else {
            // Eğer kayıt bulunamazsa veya silinmişse yeni kayıt ekle
            $sql = "INSERT INTO isletmeler (sirket_adi, sirket_unvani, adres, ilce, il, vergi_tc_no, vergi_dairesi) 
                    VALUES (?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("sssssss", $sirket_adi, $sirket_unvani, $adres, $ilce, $il, $vergi_tc_no, $vergi_dairesi);

            if ($stmt->execute()) {
                $last_id = $conn->insert_id; // Son eklenen işletme ID'sini al
                $_SESSION['last_vergi_tc'] = $vergi_tc_no; // Tekrar eklenmesini engelle
                header("Location: yonetici_kayit.php?isletme_id=" . $last_id);
                exit();
            } else {
                $error = "Kayıt eklenirken hata oluştu: " . $stmt->error;
            }
        }
    }
}
?>

<form method="POST">
    Şirket Adı: <input type="text" name="sirket_adi" required><br>
    Şirket Ünvanı: <input type="text" name="sirket_unvani" required><br>
    Adres: <textarea name="adres" required></textarea><br>
    İlçe: <input type="text" name="ilce" required><br>
    İl: <input type="text" name="il" required><br>
    Vergi / TC Kimlik No: <input type="text" name="vergi_tc_no" required><br>
    Vergi Dairesi: <input type="text" name="vergi_dairesi" required><br>
    <button type="submit">İleri</button>
</form>

<?php
if (isset($error)) {
    echo "<p style='color: red;'>$error</p>";
}
?>
