<?php
include 'db.php'; // Veritabanı bağlantısını içeren dosya

session_start(); // Oturum başlat

// İşletme ID'sini kontrol et
if (!isset($_SESSION['isletme_id'])) {
    header("Location: giris.php"); // Giriş sayfasına yönlendir
    exit();
}

$isletme_id = $_SESSION['isletme_id'];

// İşletme bilgilerini al
$sql = "SELECT id, sirket_adi, sirket_unvani, adres, ilce, il, vergi_tc_no, vergi_dairesi 
        FROM isletmeler WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $isletme_id);
$stmt->execute();
$stmt->store_result();

// Sonuç varsa verileri al
if ($stmt->num_rows > 0) {
    $stmt->bind_result($id, $sirket_adi, $sirket_unvani, $adres, $ilce, $il, $vergi_tc_no, $vergi_dairesi);
    $stmt->fetch();
} else {
    $error = "İşletme bilgileri bulunamadı.";
}

// Güncelleme işlemi
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['guncelle_isletme'])) {
    $sirket_adi = $_POST['sirket_adi'];
    $sirket_unvani = $_POST['sirket_unvani'];
    $adres = $_POST['adres'];
    $ilce = $_POST['ilce'];
    $il = $_POST['il'];
    $vergi_tc_no = $_POST['vergi_tc_no'];
    $vergi_dairesi = $_POST['vergi_dairesi'];

    $update_sql = "UPDATE isletmeler SET 
                    sirket_adi = ?, 
                    sirket_unvani = ?, 
                    adres = ?, 
                    ilce = ?, 
                    il = ?, 
                    vergi_tc_no = ?, 
                    vergi_dairesi = ? 
                    WHERE id = ?";
    $update_stmt = $conn->prepare($update_sql);
    $update_stmt->bind_param("sssssssi", $sirket_adi, $sirket_unvani, $adres, $ilce, $il, $vergi_tc_no, $vergi_dairesi, $isletme_id);

    if ($update_stmt->execute()) {
        // Güncelleme başarılı ise yönlendirme yap
        header("Location: isletme_ayarlari.php?success=1");
        exit();
    } else {
        $error = "Güncelleme sırasında hata oluştu: " . $update_stmt->error;
    }
}

// Başarılı güncelleme mesajı kontrolü
if (isset($_GET['success']) && $_GET['success'] == 1) {
    $success = "İşletme bilgileri başarıyla güncellendi.";
}

// İşletme Konumları Gösterme
$sql = "SELECT id, konum_ad, konum_alani,  konum_disi_okutma, aktif, qr_kod FROM konumlar WHERE isletme_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $isletme_id);
$stmt->execute();
$stmt->store_result();

$konumlar = [];
if ($stmt->num_rows > 0) {
    $stmt->bind_result($id, $konum_ad, $konum_alani, $konum_disi_okutma, $aktif, $qr_kod);
    while ($stmt->fetch()) {
        $konumlar[] = [
            'id' => $id,
            'konum_ad' => $konum_ad,
            'konum_alani' => $konum_alani,
            'konum_disi_okutma' => $konum_disi_okutma,
            'aktif' => $aktif,
            'qr_kod' => $qr_kod,
        ];
    }
}

// İşletme Yöneticilerini Gösterme
$sql = "SELECT id, personel_ad, personel_soyad, personel_numara, personel_mail, personel_statusu FROM personeller WHERE isletme_id = ? AND personel_statusu = 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $isletme_id);
$stmt->execute();
$stmt->store_result();

$yoneticiler = [];
if ($stmt->num_rows > 0) {
    $stmt->bind_result($id, $personel_ad, $personel_soyad, $personel_numara, $personel_mail, $personel_statusu);
    while ($stmt->fetch()) {
        $yoneticiler[] = [
            'id' => $id,
            'personel_ad' => $personel_ad,
            'personel_soyad' => $personel_soyad,
            'personel_numara' => $personel_numara, // Burada personel_numara kullanılıyor
            'personel_mail' => $personel_mail,
            'personel_statusu' => $personel_statusu,
        ];
    }
}

// Konum güncelleme işlemi
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['guncelle_konum'])) {
    $konum_id = $_POST['konum_id'];
    $konum_ad = $_POST['konum_ad'];
    $konum_alani = $_POST['konum_alani'];
    $konum_disi_okutma = $_POST['konum_disi_okutma'];
    $aktif = $_POST['aktif'];
    $qr_kod = $_POST['qr_kod'];

    $update_sql = "UPDATE konumlar SET 
                    konum_ad = ?, 
                    konum_alani = ?, 
                    konum_disi_okutma = ?, 
                    aktif = ?, 
                    qr_kod = ? 
                    WHERE id = ?";
    $update_stmt = $conn->prepare($update_sql);
    $update_stmt->bind_param("ssssssi", $konum_ad, $konum_alani,  $konum_disi_okutma, $aktif, $qr_kod, $konum_id);

    if ($update_stmt->execute()) {
        // Güncelleme başarılı ise yönlendirme yap
        header("Location: isletme_ayarlari.php?success=1");
        exit();
    } else {
        $error = "Güncelleme sırasında hata oluştu: " . $update_stmt->error;
    }
}

// Yöneticiyi güncelleme işlemi
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['guncelle_yonetici'])) {
    $yonetici_id = $_POST['yonetici_id'];
    $personel_ad = $_POST['personel_ad'];
    $personel_soyad = $_POST['personel_soyad'];
    $personel_numara = $_POST['personel_numara'];
    $personel_mail = $_POST['personel_mail'];
    $personel_statusu = $_POST['personel_statusu'];

    // Güncelleme sorgusu
    $update_sql = "UPDATE personeller SET 
                    personel_ad = ?, 
                    personel_soyad = ?, 
                    personel_numara = ?, 
                    personel_mail = ?, 
                    personel_statusu = ? 
                    WHERE id = ? AND isletme_id = ?";
    $update_stmt = $conn->prepare($update_sql);
    $update_stmt->bind_param("ssssiii", $personel_ad, $personel_soyad, $personel_numara, $personel_mail, $personel_statusu, $yonetici_id, $isletme_id);

    if ($update_stmt->execute()) {
        // Güncelleme başarılı ise yönlendirme yap
        header("Location: isletme_ayarlari.php?success=1");
        exit();
    } else {
        $error = "Güncelleme sırasında hata oluştu: " . $update_stmt->error;
    }
}

// Başarılı güncelleme mesajı kontrolü
if (isset($_GET['success']) && $_GET['success'] == 1) {
    $success = "Yönetici bilgileri başarıyla güncellendi.";
}

// Fatura güncelleme işlemi
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['guncelle_fatura'])) {
    $fatura_sirket_unvani = $_POST['fatura_sirket_unvani'];
    $fatura_adres = $_POST['fatura_adres'];
    $fatura_ilce = $_POST['fatura_ilce'];
    $fatura_il = $_POST['fatura_il'];
    $fatura_vergi_no_tc = $_POST['fatura_vergi_no_tc'];
    $fatura_vergi_dairesi = $_POST['fatura_vergi_dairesi'];

    $update_fatura_sql = "UPDATE fatura SET 
                    sirket_unvani = ?, 
                    adres = ?, 
                    ilce = ?, 
                    il = ?, 
                    vergi_no_tc = ?, 
                    vergi_dairesi = ? 
                    WHERE isletme_id = ?";
    $update_fatura_stmt = $conn->prepare($update_fatura_sql);
    $update_fatura_stmt->bind_param("ssssssi", $fatura_sirket_unvani, $fatura_adres, $fatura_ilce, $fatura_il, $fatura_vergi_no_tc, $fatura_vergi_dairesi, $isletme_id);

    if ($update_fatura_stmt->execute()) {
        // Güncelleme başarılı ise yönlendirme yap
        header("Location: isletme_ayarlari.php?success=1");
        exit();
    } else {
        $error = "Güncelleme sırasında hata oluştu: " . $update_fatura_stmt->error;
    }
}
// Çalışma saatlerini gösterme
$sql = "SELECT id, is_baslama, is_cikis, izin_gunleri, mobil_uygulama_izin_talep, 
               mobil_uygulama_saatlik_izin, izin_talep_yetkili_onayi, 
               resmi_tatillerde_calisma, gec_kalma_tolerans, erken_cikma_tolerans, 
               is_giris_cikis_bildirim 
        FROM calisma_saatleri WHERE isletme_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $isletme_id);
$stmt->execute();
$stmt->store_result();

$calisma_saatleri = [];
if ($stmt->num_rows > 0) {
    $stmt->bind_result($id, $is_baslama, $is_cikis, $izin_gunleri, $mobil_uygulama_izin_talep, 
                       $mobil_uygulama_saatlik_izin, $izin_talep_yetkili_onayi, 
                       $resmi_tatillerde_calisma, $gec_kalma_tolerans, 
                       $erken_cikma_tolerans, $is_giris_cikis_bildirim);
    while ($stmt->fetch()) {
        $calisma_saatleri[] = [
            'id' => $id,
            'is_baslama' => $is_baslama,
            'is_cikis' => $is_cikis,
            'izin_gunleri' => $izin_gunleri,
            'mobil_uygulama_izin_talep' => $mobil_uygulama_izin_talep,
            'mobil_uygulama_saatlik_izin' => $mobil_uygulama_saatlik_izin,
            'izin_talep_yetkili_onayi' => $izin_talep_yetkili_onayi,
            'resmi_tatillerde_calisma' => $resmi_tatillerde_calisma,
            'gec_kalma_tolerans' => $gec_kalma_tolerans,
            'erken_cikma_tolerans' => $erken_cikma_tolerans,
            'is_giris_cikis_bildirim' => $is_giris_cikis_bildirim,
        ];
    }
}
// Çalışma saatlerini güncelleme işlemi
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['guncelle_calisma_saatleri'])) {
    $calisma_id = $_POST['calisma_id'];
    $is_baslama = $_POST['is_baslama'];
    $is_cikis = $_POST['is_cikis'];
    $izin_gunleri = $_POST['izin_gunleri'];
    
    // Evet/Hayır değerlerini 1/0 olarak ayarlama
    $mobil_uygulama_izin_talep = ($_POST['mobil_uygulama_izin_talep'] == '1') ? 1 : 0;
    $mobil_uygulama_saatlik_izin = ($_POST['mobil_uygulama_saatlik_izin'] == '1') ? 1 : 0;
    $izin_talep_yetkili_onayi = ($_POST['izin_talep_yetkili_onayi'] == '1') ? 1 : 0;
    $resmi_tatillerde_calisma = ($_POST['resmi_tatillerde_calisma'] == '1') ? 1 : 0;
    
    // Geç Kalma ve Erken Çıkma Toleranslarını al
    $gec_kalma_tolerans = $_POST['gec_kalma_tolerans'];
    $erken_cikma_tolerans = $_POST['erken_cikma_tolerans'];
    
    // İş Giriş Çıkış Bildirim değerini 1/0 olarak ayarlama
    $is_giris_cikis_bildirim = ($_POST['is_giris_cikis_bildirim'] == '1') ? 1 : 0;

    // Güncelleme sorgusu
    $update_sql = "UPDATE calisma_saatleri SET 
                    is_baslama = ?, 
                    is_cikis = ?, 
                    izin_gunleri = ?, 
                    mobil_uygulama_izin_talep = ?, 
                    mobil_uygulama_saatlik_izin = ?, 
                    izin_talep_yetkili_onayi = ?, 
                    resmi_tatillerde_calisma = ?, 
                    gec_kalma_tolerans = ?, 
                    erken_cikma_tolerans = ?, 
                    is_giris_cikis_bildirim = ? 
                    WHERE id = ?";
    $update_stmt = $conn->prepare($update_sql);

    // Parametrelerin sayısını kontrol edin
    $update_stmt->bind_param("ssssssssssi", $is_baslama, $is_cikis, $izin_gunleri, 
                              $mobil_uygulama_izin_talep, $mobil_uygulama_saatlik_izin, 
                              $izin_talep_yetkili_onayi, $resmi_tatillerde_calisma, 
                              $gec_kalma_tolerans, $erken_cikma_tolerans, 
                              $is_giris_cikis_bildirim, $calisma_id);

    if ($update_stmt->execute()) {
        header("Location: isletme_ayarlari.php?success=1");
        exit();
    } else {
        $error = "Güncelleme sırasında hata oluştu: " . $update_stmt->error;
    }
}

?>


<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <meta name="description" content="">
        <meta name="author" content="Tooplate">

        <title>ENPDKS</title>

        <!-- CSS FILES -->      
        <link rel="preconnect" href="https://fonts.googleapis.com">
        
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

        <link href="https://fonts.googleapis.com/css2?family=Unbounded:wght@300;400;700&display=swap" rel="stylesheet">

        <link href="css/bootstrap.min.css" rel="stylesheet">

        <link href="css/bootstrap-icons.css" rel="stylesheet">

        <link href="css/apexcharts.css" rel="stylesheet">

        <link href="css/tooplate-mini-finance.css" rel="stylesheet">
<!--

Tooplate 2135 Mini Finance

https://www.tooplate.com/view/2135-mini-finance

Bootstrap 5 Dashboard Admin Template

-->

    </head>
    
    <body>
        <header class="navbar sticky-top flex-md-nowrap">
            <div class="col-md-3 col-lg-3 me-0 px-3 fs-6">
                <a class="navbar-brand" href="panel.php">
                    <i class="bi-box"></i>
                    ENPDKS
                </a>
            </div>

            <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu" aria-controls="sidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <form class="custom-form header-form ms-lg-3 ms-md-3 me-lg-auto me-md-auto order-2 order-lg-0 order-md-0" action="#" method="get" role="form">
                <input class="form-control" name="search" type="text" placeholder="Search" aria-label="Search">
            </form>

            <div class="navbar-nav me-lg-2">
                <div class="nav-item text-nowrap d-flex align-items-center">
                    <div class="dropdown ps-3">
                        <a class="nav-link dropdown-toggle text-center" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" id="navbarLightDropdownMenuLink">
                            <i class="bi-bell"></i>
                            <span class="position-absolute start-100 translate-middle p-1 bg-danger border border-light rounded-circle">
                                <span class="visually-hidden">New alerts</span>
                            </span>
                        </a>

                        <ul class="dropdown-menu dropdown-menu-lg-end notifications-block-wrap bg-white shadow" aria-labelledby="navbarLightDropdownMenuLink">
                            <small>Bildirimler</small>

                            <li class="notifications-block border-bottom pb-2 mb-2">
                                <a class="dropdown-item d-flex  align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-success">
                                        <i class="notifications-icon bi-check-circle-fill"></i>
                                    </div>

                                    <div>
                                        <span>Your account has been created successfuly.</span>

                                        <p>12 days ago</p>
                                    </div>
                                </a>
                            </li>

                            <li class="notifications-block border-bottom pb-2 mb-2">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-info">
                                        <i class="notifications-icon bi-folder"></i>
                                    </div>

                                    <div>
                                        <span>Please check. We have sent a Daily report.</span>

                                        <p>10 days ago</p>
                                    </div>
                                </a>
                            </li>

                            <li class="notifications-block">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-danger">
                                        <i class="notifications-icon bi-question-circle"></i>
                                    </div>

                                    <div>
                                        <span>Account verification failed.</span>

                                        <p>1 hour ago</p>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </div>

              

                    <div class="dropdown px-3">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid" alt="">
                        </a>
                        <ul class="dropdown-menu bg-white shadow">
                            <li>
                                <div class="dropdown-menu-profile-thumb d-flex">
                                    <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid me-3" alt="">

                                    <div class="d-flex flex-column">
                                        <small>Thomas</small>
                                        <a href="#">thomas@site.com</a>
                                    </div>
                                </div>
                            </li>

                            <li>
                                <a class="dropdown-item" href="profile.html">
                                    <i class="bi-person me-2"></i>
                                    Profil
                                </a>
                            </li>

                            <li>
                                <a class="dropdown-item" href="setting.html">
                                    <i class="bi-gear me-2"></i>
                                    Ayarlar
                                </a>
                            </li>

                            <li>
                                <a class="dropdown-item" href="help-center.html">
                                    <i class="bi-question-circle me-2"></i>
                                    Yardım
                                </a>
                            </li>

                            <li class="border-top mt-3 pt-2 mx-4">
                                <a class="dropdown-item ms-0 me-0" href="#">
                                    <i class="bi-box-arrow-left me-2"></i>
                                    Çıkış Yap
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </header>
      
        <div class="container-fluid">
            <div class="row">
                <nav id="sidebarMenu" class="col-md-3 col-lg-3 d-md-block sidebar collapse">
                    <div class="position-sticky py-4 px-3 sidebar-sticky">
                        <ul class="nav flex-column h-100">
                            <li class="nav-item">
                                <a class="nav-link  " aria-current="page" href="panel.php">
                                    <i class="bi-house-fill me-2"></i>
                                    Ana Ekran
                                </a>
                            </li>
                            
                            <li class="nav-item">
                                <a class="nav-link" href="personel_kayit.php">
                                    Personel Kayıt
                                </a>
                            </li>
                            
                                <li class="nav-item">
                                <a class="nav-link " href="personel_liste.php">
                                    Personel Listesi
                                </a>
                            </li>
                              <li class="nav-item">
                                <a class="nav-link " href="konum.php">
                                    Konum İşlemleri
                                </a>
                            </li>
                             <li class="nav-item">
                                <a class="nav-link " href="bildirim.php">
                                    Bildirim Gönder
                                </a>
                            </li>
                             <li class="nav-item">
                                <a class="nav-link " href="bildirim_liste.php">
                                    Bildirim Listesi
                                </a>
                            </li>
 <ul class="nav">
        <li class="nav-item">
            <a class="nav-link " onclick="toggleSubMenu()">Grup İşlemleri</a>
            <div class="sub-menu">
                <p><a href="etiket_ekle.php">Grup Ekle</a></p>
                <p><a href="etiketler.php">Grupları Listele</a></p>
            </div>
        </li>
    </ul>
     <a class="nav-link active" href="isletme_ayarlari.php">
                                    <i class="bi-gear me-2"></i>
                                    İşletme Ayarları
                                </a>
                            </li>




                            <li class="nav-item">
                                <a class="nav-link" href="wallet.html">
                                    <i class="bi-wallet me-2"></i>
                                    My Wallet
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="profile.html">
                                    <i class="bi-person me-2"></i>
                                    Profile
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="setting.html">
                                    <i class="bi-gear me-2"></i>
                                    Settings
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="help-center.html">
                                    <i class="bi-question-circle me-2"></i>
                                    Help Center
                                </a>
                            </li>

                            <li class="nav-item featured-box mt-lg-5 mt-4 mb-4">
                                <img src="images/credit-card.png" class="img-fluid" alt="">

                                <a class="btn custom-btn" href="#">Upgrade</a>
                            </li>

                            <li class="nav-item border-top mt-auto pt-2">
                                <a class="nav-link" href="#">
                                    <i class="bi-box-arrow-left me-2"></i>
                                    Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                </nav>
                  <style>
           .sub-menu {
            display: none;
            margin-left: 20px;
        }
        .nav-link {
            cursor: pointer;
        }
        .sub-menu p {
            color: black; /* Paragrafların rengi siyah */
            margin: 0; /* Varsayılan margin'i sıfırlamak için */
        }
    </style>
    
     <script>
        function toggleSubMenu() {
            const subMenu = document.querySelector('.sub-menu');
            subMenu.style.display = subMenu.style.display === 'none' || subMenu.style.display === '' ? 'block' : 'none';
        }
    </script>
<main class="main-wrapper col-md-9 ms-sm-auto py-4 col-lg-9 px-md-4 border-start">
    <div class="title-group mb-3">
        <h1 class="h2 mb-0">İşletme Ayarları</h1>
    </div>

    <?php if (isset($error)) { echo "<p style='color: red;'>$error</p>"; } ?>
    <?php if (isset($success)) { echo "<p style='color: green;'>$success</p>"; } ?>

    <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile-tab-pane" type="button" role="tab" aria-controls="profile-tab-pane" aria-selected="true">İşletme Bilgileri</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="location-tab" data-bs-toggle="tab" data-bs-target="#location-tab-pane" type="button" role="tab" aria-controls="location-tab-pane" aria-selected="false">İşletme Konumları</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="staff-tab" data-bs-toggle="tab" data-bs-target="#staff-tab-pane" type="button" role="tab" aria-controls="staff-tab-pane" aria-selected="false">İşletme Yöneticileri</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="invoice-tab" data-bs-toggle="tab" data-bs-target="#invoice-tab-pane" type="button" role="tab" aria-controls="invoice-tab-pane" aria-selected="false">Fatura Bilgileri</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="working-hours-tab" data-bs-toggle="tab" data-bs-target="#working-hours-tab-pane" type="button" role="tab" aria-controls="working-hours-tab-pane" aria-selected="false">Çalışma Saatleri</button>
        </li>
    </ul>

    <div class="tab-content" id="myTabContent">
        <!-- İşletme Bilgileri -->
        <div class="tab-pane fade show active" id="profile-tab-pane" role="tabpanel" aria-labelledby="profile-tab" tabindex="0">
            <h6 class="mb-4">İşletme Bilgileri</h6>

            <form method="POST">
                <label>Şirket Adı:</label>
                <input class="form-control" type="text" name="sirket_adi" value="<?php echo htmlspecialchars($sirket_adi); ?>" required><br>

                <label>Şirket Ünvanı:</label>
                <input class="form-control" type="text" name="sirket_unvani" value="<?php echo htmlspecialchars($sirket_unvani); ?>" required><br>

                <label>Adres:</label>
                <textarea class="form-control" name="adres" required><?php echo htmlspecialchars($adres); ?></textarea><br>

                <label>İlçe:</label>
                <input class="form-control" type="text" name="ilce" value="<?php echo htmlspecialchars($ilce); ?>" required><br>

                <label>İl:</label>
                <input class="form-control" type="text" name="il" value="<?php echo htmlspecialchars($il); ?>" required><br>

                <label>Vergi / TC Kimlik No:</label>
                <input class="form-control" type="text" name="vergi_tc_no" value="<?php echo htmlspecialchars($vergi_tc_no); ?>" required><br>

                <label>Vergi Dairesi:</label>
                <input class="form-control" type="text" name="vergi_dairesi" value="<?php echo htmlspecialchars($vergi_dairesi); ?>" required><br>

                <div class="d-flex">
                    <button type="button" class="form-control me-3">Sıfırla</button>
                    <button type="submit" name="guncelle_isletme" class="form-control ms-2">Güncelle</button>
                </div>
            </form>
        </div>

        <!-- İşletme Konumları -->
        <div class="tab-pane fade" id="location-tab-pane" role="tabpanel" aria-labelledby="location-tab" tabindex="0">
            <h6 class="mb-4">İşletme Konumları</h6>

            <?php foreach ($konumlar as $konum): ?>
                <form method="POST">
                    <input type="hidden" name="konum_id" value="<?php echo $konum['id']; ?>">
                    <label>Konum Adı:</label>
                    <input class="form-control" type="text" name="konum_ad" value="<?php echo htmlspecialchars($konum['konum_ad']); ?>" required><br>

                    <label>Konum Alanı:</label>
                    <input class="form-control" type="text" name="konum_alani" value="<?php echo htmlspecialchars($konum['konum_alani']); ?>" required><br>

                   
                    <label>Konum Dışı Okutma:</label>
                    <select class="form-control" name="konum_disi_okutma">
                        <option value="1" <?php echo $konum['konum_disi_okutma'] == 1 ? 'selected' : ''; ?>>Aktif</option>
                        <option value="0" <?php echo $konum['konum_disi_okutma'] == 0 ? 'selected' : ''; ?>>Pasif</option>
                    </select><br>

                    <label>Aktif:</label>
                    <select class="form-control" name="aktif">
                        <option value="1" <?php echo $konum['aktif'] == 1 ? 'selected' : ''; ?>>Aktif</option>
                        <option value="0" <?php echo $konum['aktif'] == 0 ? 'selected' : ''; ?>>Pasif</option>
                    </select><br>

                    <label>QR Kod Görseli:</label>
                    <input class="form-control" type="file" name="qr_kod" accept="image/*"><br>

                    <div class="d-flex">
                        <button type="button" class="form-control me-3">Sıfırla</button>
                        <button type="submit" name="guncelle_konum" class="form-control ms-2">Güncelle</button>
                    </div>
                </form>
                <hr>
            <?php endforeach; ?>
        </div>

        <!-- İşletme Yöneticileri -->
        <div class="tab-pane fade" id="staff-tab-pane" role="tabpanel" aria-labelledby="staff-tab" tabindex="0">
            <h6 class="mb-4">İşletme Yöneticileri</h6>

            <?php foreach ($yoneticiler as $yonetici): ?>
                <form method="POST">
                    <input type="hidden" name="yonetici_id" value="<?php echo $yonetici['id']; ?>">
                    <label>Personel Adı:</label>
                    <input class="form-control" type="text" name="personel_ad" value="<?php echo htmlspecialchars($yonetici['personel_ad']); ?>" required><br>

                    <label>Personel Soyadı:</label>
                    <input class="form-control" type="text" name="personel_soyad" value="<?php echo htmlspecialchars($yonetici['personel_soyad']); ?>" required><br>

                    <label>Telefon Numarası:</label>
                    <input class="form-control" type="text" name="personel_numara" value="<?php echo htmlspecialchars($yonetici['personel_numara'] ?? ''); ?>" required><br>

                    <label>Personel Mail:</label>
                    <input class="form-control" type="email" name="personel_mail" value="<?php echo htmlspecialchars($yonetici['personel_mail']); ?>" required><br>

                    <label>Personel Durumu:</label>
                    <select class="form-control" name="personel_statusu">
                        <option value="1" <?php echo $yonetici['personel_statusu'] == 1 ? 'selected' : ''; ?>>Aktif</option>
                        <option value="0" <?php echo $yonetici['personel_statusu'] == 0 ? 'selected' : ''; ?>>Pasif</option>
                    </select><br>

                    <div class="d-flex">
                        <button type="button" class="form-control me-3">Sıfırla</button>
                        <button type="submit" name="guncelle_yonetici" class="form-control ms-2">Güncelle</button>
                    </div>
                </form>
                <hr>
            <?php endforeach; ?>
        </div>

        <!-- Fatura Bilgileri -->
        <div class="tab-pane fade" id="invoice-tab-pane" role="tabpanel" aria-labelledby="invoice-tab" tabindex="0">
            <h6 class="mb-4">Fatura Bilgileri</h6>

            <?php
            // Fatura bilgilerini al
            $fatura_sql = "SELECT sirket_unvani, adres, ilce, il, vergi_no_tc, vergi_dairesi FROM fatura WHERE isletme_id = ?";
            $fatura_stmt = $conn->prepare($fatura_sql);
            $fatura_stmt->bind_param("i", $isletme_id);
            $fatura_stmt->execute();
            $fatura_stmt->store_result();

            if ($fatura_stmt->num_rows > 0) {
                $fatura_stmt->bind_result($fatura_sirket_unvani, $fatura_adres, $fatura_ilce, $fatura_il, $fatura_vergi_no_tc, $fatura_vergi_dairesi);
                $fatura_stmt->fetch();
            ?>
                <form method="POST">
                    <label>Şirket Ünvanı:</label>
                    <input class="form-control" type="text" name="fatura_sirket_unvani" value="<?php echo htmlspecialchars($fatura_sirket_unvani); ?>" required><br>

                    <label>Adres:</label>
                    <textarea class="form-control" name="fatura_adres" required><?php echo htmlspecialchars($fatura_adres); ?></textarea><br>

                    <label>İlçe:</label>
                    <input class="form-control" type="text" name="fatura_ilce" value="<?php echo htmlspecialchars($fatura_ilce); ?>" required><br>

                    <label>İl:</label>
                    <input class="form-control" type="text" name="fatura_il" value="<?php echo htmlspecialchars($fatura_il); ?>" required><br>

                    <label>Vergi No / TC Kimlik No:</label>
                    <input class="form-control" type="text" name="fatura_vergi_no_tc" value="<?php echo htmlspecialchars($fatura_vergi_no_tc); ?>" required><br>

                    <label>Vergi Dairesi:</label>
                    <input class="form-control" type="text" name="fatura_vergi_dairesi" value="<?php echo htmlspecialchars($fatura_vergi_dairesi); ?>" required><br>

                    <div class="d-flex">
                        <button type="button" class="form-control me-3">Sıfırla</button>
                        <button type="submit" name="guncelle_fatura" class="form-control ms-2">Güncelle</button>
                    </div>
                </form>
            <?php
            } else {
                echo "<p>Fatura bilgisi bulunamadı.</p>";
            }
            ?>
        </div>

     <!-- Çalışma Saatleri -->
<div class="tab-pane fade" id="working-hours-tab-pane" role="tabpanel" aria-labelledby="working-hours-tab" tabindex="0">
    <h6 class="mb-4">Çalışma Saatleri</h6>

    <?php if (!empty($calisma_saatleri)): ?>
        <?php foreach ($calisma_saatleri as $calisma): ?>
            <form method="POST">
                <input type="hidden" name="calisma_id" value="<?php echo $calisma['id']; ?>">

                <label>İş Başlama Saati:</label>
                <input class="form-control" type="time" name="is_baslama" value="<?php echo htmlspecialchars($calisma['is_baslama']); ?>" required><br>

                <label>İş Çıkış Saati:</label>
                <input class="form-control" type="time" name="is_cikis" value="<?php echo htmlspecialchars($calisma['is_cikis']); ?>" required><br>

                <label>İzin Günleri:</label>
                <input class="form-control" type="text" name="izin_gunleri" value="<?php echo htmlspecialchars($calisma['izin_gunleri']); ?>" required><br>

                <label>Mobil Uygulama İzin Talep:</label>
                <select class="form-control" name="mobil_uygulama_izin_talep">
                    <option value="1" <?php echo $calisma['mobil_uygulama_izin_talep'] == 1 ? 'selected' : ''; ?>>Evet</option>
                    <option value="0" <?php echo $calisma['mobil_uygulama_izin_talep'] == 0 ? 'selected' : ''; ?>>Hayır</option>
                </select><br>

                <label>Mobil Uygulama Saatlik İzin:</label>
                <select class="form-control" name="mobil_uygulama_saatlik_izin">
                    <option value="1" <?php echo $calisma['mobil_uygulama_saatlik_izin'] == 1 ? 'selected' : ''; ?>>Evet</option>
                    <option value="0" <?php echo $calisma['mobil_uygulama_saatlik_izin'] == 0 ? 'selected' : ''; ?>>Hayır</option>
                </select><br>

                <label>İzin Talep Yetkili Onayı:</label>
                <select class="form-control" name="izin_talep_yetkili_onayi">
                    <option value="1" <?php echo $calisma['izin_talep_yetkili_onayi'] == 1 ? 'selected' : ''; ?>>Evet</option>
                    <option value="0" <?php echo $calisma['izin_talep_yetkili_onayi'] == 0 ? 'selected' : ''; ?>>Hayır</option>
                </select><br>

                <label>Resmi Tatillerde Çalışma:</label>
                <select class="form-control" name="resmi_tatillerde_calisma">
                    <option value="1" <?php echo $calisma['resmi_tatillerde_calisma'] == 1 ? 'selected' : ''; ?>>Evet</option>
                    <option value="0" <?php echo $calisma['resmi_tatillerde_calisma'] == 0 ? 'selected' : ''; ?>>Hayır</option>
                </select><br>

                <label>Geç Kalma Toleransı:</label>
                <select class="form-control" name="gec_kalma_tolerans">
                    <option value="1" <?php echo $calisma['gec_kalma_tolerans'] == 1 ? 'selected' : ''; ?>>Evet</option>
                    <option value="0" <?php echo $calisma['gec_kalma_tolerans'] == 0 ? 'selected' : ''; ?>>Hayır</option>
                </select><br>

                <label>Erken Çıkma Toleransı:</label>
                <select class="form-control" name="erken_cikma_tolerans">
                    <option value="1" <?php echo $calisma['erken_cikma_tolerans'] == 1 ? 'selected' : ''; ?>>Evet</option>
                    <option value="0" <?php echo $calisma['erken_cikma_tolerans'] == 0 ? 'selected' : ''; ?>>Hayır</option>
                </select><br>

                <label>İş Giriş Çıkış Bildirim:</label>
                <select class="form-control" name="is_giris_cikis_bildirim">
                    <option value="1" <?php echo $calisma['is_giris_cikis_bildirim'] == 1 ? 'selected' : ''; ?>>Evet</option>
                    <option value="0" <?php echo $calisma['is_giris_cikis_bildirim'] == 0 ? 'selected' : ''; ?>>Hayır</option>
                </select><br>

                <div class="d-flex">
                    <button type="button" class="form-control me-3">Sıfırla</button>
                    <button type="submit" name="guncelle_calisma_saatleri" class="form-control ms-2">Güncelle</button>
                </div>
            </form>
            <hr>
        <?php endforeach; ?>
    <?php else: ?>
        <p>Çalışma saatleri bilgisi bulunamadı.</p>
    <?php endif; ?>
</div>

    </div>
</main>



<script src="js/jquery.min.js"></script>
<script src="js/bootstrap.bundle.min.js"></script>
<script src="js/custom.js"></script>
