<?php
include 'db.php';
session_start();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $isletme_id = $_POST['isletme_id'];
    $sirket_unvani = $_POST['sirket_unvani'];
    $adres = $_POST['adres'];
    $ilce = $_POST['ilce'];
    $il = $_POST['il'];
    $vergi_no_tc = $_POST['vergi_no_tc'];
    $vergi_dairesi = $_POST['vergi_dairesi'];

    // Fatura bilgilerini ekle
    $sql = "INSERT INTO fatura (isletme_id, sirket_unvani, adres, ilce, il, vergi_no_tc, vergi_dairesi) 
            VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("issssss", $isletme_id, $sirket_unvani, $adres, $ilce, $il, $vergi_no_tc, $vergi_dairesi);

    if ($stmt->execute()) {
        // Fatura kaydı başarılıysa, çalışma saatleri kaydını ekle
        $insert_calisma_sql = "INSERT INTO calisma_saatleri (isletme_id) VALUES (?)";
        $insert_calisma_stmt = $conn->prepare($insert_calisma_sql);
        $insert_calisma_stmt->bind_param("i", $isletme_id);

        if ($insert_calisma_stmt->execute()) {
            echo "İşletmeniz başarıyla kaydedilmiştir ve çalışma saatleri otomatik olarak oluşturulmuştur. <a href='personel_giris.php'>Giriş yap</a>";
        } else {
            echo "Fatura kaydedildi ancak çalışma saatleri eklenirken hata oluştu: " . $insert_calisma_stmt->error;
        }
    } else {
        echo "Kayıt eklenirken hata oluştu: " . $stmt->error;
    }
}
?>

<form method="POST">
    <input type="hidden" name="isletme_id" value="<?= htmlspecialchars($_GET['isletme_id']); ?>">
    Şirket Ünvanı: <input type="text" name="sirket_unvani" required><br>
    Adres: <input type="text" name="adres" required><br>
    İlçe: <input type="text" name="ilce" required><br>
    İl: <input type="text" name="il" required><br>
    Vergi No/Tc Kimlik No: <input type="text" name="vergi_no_tc" required><br>
    Vergi Dairesi: <input type="text" name="vergi_dairesi" required><br>
    <button type="submit">Fatura Bilgilerini Kaydet</button>
</form>
