<?php
session_start();
include 'db.php';

// Kullanıcı giriş yapmamışsa yönlendir
if (!isset($_SESSION['isletme_id'])) {
    header("Location: yonetici_giris.php");
    exit();
}

$isletme_id = $_SESSION['isletme_id'];


// Etiket güncelleme işlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['guncelle'])) {
    $etiket_id = $_POST['etiket_id'];
    $yeni_ad = $_POST['yeni_ad'];

    $sql = "UPDATE etiketler SET etiket_adi = ? WHERE id = ? AND isletme_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sii", $yeni_ad, $etiket_id, $isletme_id);
    $stmt->execute();
    $stmt->close();
}

// Etiket silme işlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['sil'])) {
    $etiket_id = $_POST['etiket_id'];
    $sql = "DELETE FROM etiketler WHERE id = ? AND isletme_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $etiket_id, $isletme_id);
    $stmt->execute();
    $stmt->close();
}

// Etiketleri çekme işlemi
$sql = "SELECT id, etiket_adi FROM etiketler WHERE isletme_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $isletme_id);
$stmt->execute();
$stmt->bind_result($id, $etiket_adi);
?>

<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <meta name="description" content="">
        <meta name="author" content="Tooplate">

        <title>ENPDKS</title>

        <!-- CSS FILES -->      
        <link rel="preconnect" href="https://fonts.googleapis.com">
        
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

        <link href="https://fonts.googleapis.com/css2?family=Unbounded:wght@300;400;700&display=swap" rel="stylesheet">

        <link href="css/bootstrap.min.css" rel="stylesheet">

        <link href="css/bootstrap-icons.css" rel="stylesheet">

        <link href="css/apexcharts.css" rel="stylesheet">

        <link href="css/tooplate-mini-finance.css" rel="stylesheet">
<!--

Tooplate 2135 Mini Finance

https://www.tooplate.com/view/2135-mini-finance

Bootstrap 5 Dashboard Admin Template

-->

    </head>
    
    <body>
        <header class="navbar sticky-top flex-md-nowrap">
            <div class="col-md-3 col-lg-3 me-0 px-3 fs-6">
                <a class="navbar-brand" href="panel.php">
                    <i class="bi-box"></i>
                    ENPDKS
                </a>
            </div>

            <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu" aria-controls="sidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <form class="custom-form header-form ms-lg-3 ms-md-3 me-lg-auto me-md-auto order-2 order-lg-0 order-md-0" action="#" method="get" role="form">
                <input class="form-control" name="search" type="text" placeholder="Search" aria-label="Search">
            </form>

            <div class="navbar-nav me-lg-2">
                <div class="nav-item text-nowrap d-flex align-items-center">
                    <div class="dropdown ps-3">
                        <a class="nav-link dropdown-toggle text-center" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" id="navbarLightDropdownMenuLink">
                            <i class="bi-bell"></i>
                            <span class="position-absolute start-100 translate-middle p-1 bg-danger border border-light rounded-circle">
                                <span class="visually-hidden">New alerts</span>
                            </span>
                        </a>

                        <ul class="dropdown-menu dropdown-menu-lg-end notifications-block-wrap bg-white shadow" aria-labelledby="navbarLightDropdownMenuLink">
                            <small>Bildirimler</small>

                            <li class="notifications-block border-bottom pb-2 mb-2">
                                <a class="dropdown-item d-flex  align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-success">
                                        <i class="notifications-icon bi-check-circle-fill"></i>
                                    </div>

                                    <div>
                                        <span>Your account has been created successfuly.</span>

                                        <p>12 days ago</p>
                                    </div>
                                </a>
                            </li>

                            <li class="notifications-block border-bottom pb-2 mb-2">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-info">
                                        <i class="notifications-icon bi-folder"></i>
                                    </div>

                                    <div>
                                        <span>Please check. We have sent a Daily report.</span>

                                        <p>10 days ago</p>
                                    </div>
                                </a>
                            </li>

                            <li class="notifications-block">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-danger">
                                        <i class="notifications-icon bi-question-circle"></i>
                                    </div>

                                    <div>
                                        <span>Account verification failed.</span>

                                        <p>1 hour ago</p>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </div>

              

                    <div class="dropdown px-3">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid" alt="">
                        </a>
                        <ul class="dropdown-menu bg-white shadow">
                            <li>
                                <div class="dropdown-menu-profile-thumb d-flex">
                                    <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid me-3" alt="">

                                    <div class="d-flex flex-column">
                                        <small>Thomas</small>
                                        <a href="#">thomas@site.com</a>
                                    </div>
                                </div>
                            </li>

                            <li>
                                <a class="dropdown-item" href="profile.html">
                                    <i class="bi-person me-2"></i>
                                    Profil
                                </a>
                            </li>

                            <li>
                                <a class="dropdown-item" href="setting.html">
                                    <i class="bi-gear me-2"></i>
                                    Ayarlar
                                </a>
                            </li>

                            <li>
                                <a class="dropdown-item" href="help-center.html">
                                    <i class="bi-question-circle me-2"></i>
                                    Yardım
                                </a>
                            </li>

                            <li class="border-top mt-3 pt-2 mx-4">
                                <a class="dropdown-item ms-0 me-0" href="#">
                                    <i class="bi-box-arrow-left me-2"></i>
                                    Çıkış Yap
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </header>

        <div class="container-fluid">
            <div class="row">
                <nav id="sidebarMenu" class="col-md-3 col-lg-3 d-md-block sidebar collapse">
                    <div class="position-sticky py-4 px-3 sidebar-sticky">
                        <ul class="nav flex-column h-100">
                            <li class="nav-item">
                                <a class="nav-link " aria-current="page" href="panel.php">
                                    <i class="bi-house-fill me-2"></i>
                                    Ana Ekran
                                </a>
                            </li>
                            
                            <li class="nav-item">
                                <a class="nav-link" href="personel_kayit.php">
                                    Personel Kayıt
                                </a>
                            </li>
                            
                                <li class="nav-item">
                                <a class="nav-link " href="personel_liste.php">
                                    Personel Listesi
                                </a>
                            </li>
                              <li class="nav-item">
                                <a class="nav-link " href="konum.php">
                                    Konum İşlemleri
                                </a>
                            </li>
                             <li class="nav-item">
                                <a class="nav-link " href="bildirim.php">
                                    Bildirim Gönder
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link " href="bildirim_liste.php">
                                    Bildirim Listesi
                                </a>
                            </li>
 <ul class="nav">
        <li class="nav-item">
            <a class="nav-link active" onclick="toggleSubMenu()">Etiket İşlemleri</a>
            <div class="sub-menu">
                <p><a href="etiket_ekle.php">Grup Ekle</a></p>
                <p><a href="etiketler.php">Grupları Listele</a></p>
            </div>
        </li>
    </ul>

 <a class="nav-link" href="isletme_ayarlari.php">
                                    <i class="bi-gear me-2"></i>
                                    İşletme Ayarları
                                </a>
                            </li>


                            <li class="nav-item">
                                <a class="nav-link" href="wallet.html">
                                    <i class="bi-wallet me-2"></i>
                                    My Wallet
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="profile.html">
                                    <i class="bi-person me-2"></i>
                                    Profile
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="setting.html">
                                    <i class="bi-gear me-2"></i>
                                    Settings
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="help-center.html">
                                    <i class="bi-question-circle me-2"></i>
                                    Help Center
                                </a>
                            </li>

                            <li class="nav-item featured-box mt-lg-5 mt-4 mb-4">
                                <img src="images/credit-card.png" class="img-fluid" alt="">

                                <a class="btn custom-btn" href="#">Upgrade</a>
                            </li>

                            <li class="nav-item border-top mt-auto pt-2">
                                <a class="nav-link" href="#">
                                    <i class="bi-box-arrow-left me-2"></i>
                                    Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                </nav>
                  <style>
           .sub-menu {
            display: none;
            margin-left: 20px;
        }
        .nav-link {
            cursor: pointer;
        }
        .sub-menu p {
            color: black; /* Paragrafların rengi siyah */
            margin: 0; /* Varsayılan margin'i sıfırlamak için */
        }
    </style>
    
     <script>
        function toggleSubMenu() {
            const subMenu = document.querySelector('.sub-menu');
            subMenu.style.display = subMenu.style.display === 'none' || subMenu.style.display === '' ? 'block' : 'none';
        }
    </script>
   <main class="main-wrapper col-md-9 ms-sm-auto py-4 col-lg-9 px-md-4 border-start">
    <div class="title-group mb-3">
        <h1 class="h2 mb-0">Eklenen Gruplar</h1>
    </div>

    <div class="row my-4">
        <div class="col-lg-12 col-12">
            <div class="custom-block bg-white">
                <h5 class="mb-4">Eklenen Gruplar</h5>

                <div class="table-responsive">
                    <table class="account-table table">
                        <thead>
                            <tr>
                                <th scope="col">Grup ID</th>
                                <th scope="col">Grup Adı</th>
                                <th scope="col">İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($stmt->fetch()) { ?>
                                <tr>
                                    <td><?= htmlspecialchars($id) ?></td>
                                    <td>
                                        <span class="etiket-adi" data-id="<?= $id ?>"><?= htmlspecialchars($etiket_adi) ?></span>
                                        <input type="text" class="edit-input" data-id="<?= $id ?>" value="<?= htmlspecialchars($etiket_adi) ?>" style="display:none;">
                                    </td>
                                    <td>
                                        <button class="edit-btn" data-id="<?= $id ?>">Düzenle</button>
                                        <button class="delete-btn" data-id="<?= $id ?>">Sil</button>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
document.querySelectorAll('.edit-btn').forEach(button => {
    button.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        const etiketAdiElement = document.querySelector(`.etiket-adi[data-id="${id}"]`);
        const editInput = document.querySelector(`.edit-input[data-id="${id}"]`);

        etiketAdiElement.style.display = 'none';
        editInput.style.display = 'block';
        editInput.focus();

        editInput.addEventListener('blur', function() {
            const yeniAd = this.value;
            fetch('', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `guncelle=1&etiket_id=${id}&yeni_ad=${encodeURIComponent(yeniAd)}`
            }).then(() => {
                etiketAdiElement.textContent = yeniAd;
                etiketAdiElement.style.display = 'block';
                editInput.style.display = 'none';
            });
        });
    });
});

document.querySelectorAll('.delete-btn').forEach(button => {
    button.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        if (confirm('Emin misiniz? Bu işlem geri alınamaz.')) {
            fetch('', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `sil=1&etiket_id=${id}`
            }).then(() => {
                location.reload(); // Sayfayı yeniden yükle
            });
        }
    });
});
</script>