<?php
include 'db.php';
session_start();

// İşletme ID'sini oturumdan al
$isletme_id = $_SESSION['isletme_id'];

// Konumları ve etiketleri veritabanından çek
$konumlar_sql = "SELECT * FROM konumlar WHERE isletme_id = ?";
$etiketler_sql = "SELECT * FROM etiketler WHERE isletme_id = ?";

// Konumları çek
$konum_stmt = $conn->prepare($konumlar_sql);
$konum_stmt->bind_param("i", $isletme_id);
$konum_stmt->execute();
$konum_stmt->store_result();
$konum_stmt->bind_result($konum_id, $konum_isletme_id, $konum_ad, $konum_alani,  $konum_disi_okutma, $aktif, $qr_kod);

// Etiketleri çek
$etiket_stmt = $conn->prepare($etiketler_sql);
$etiket_stmt->bind_param("i", $isletme_id);
$etiket_stmt->execute();
$etiket_stmt->store_result();
$etiket_stmt->bind_result($etiket_id, $etiket_isletme_id, $etiket_adi);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $konum_id = $_POST['konum_id'];
    $etiket_id = $_POST['etiket_id'] ?? null; // Zorunlu değil
    $baslangic_saat = $_POST['baslangic_saat'];
    $cikis_saat = $_POST['cikis_saat'];

    // Çalışma planını ekle
    $insert_sql = "INSERT INTO calisma_plani (isletme_id, konum_id, etiket_id, baslangic_saat, cikis_saat) 
                   VALUES (?, ?, ?, ?, ?)";
    $insert_stmt = $conn->prepare($insert_sql);
    $insert_stmt->bind_param("iiiss", $isletme_id, $konum_id, $etiket_id, $baslangic_saat, $cikis_saat);

    if ($insert_stmt->execute()) {
        echo "Çalışma planı başarıyla kaydedildi.";
    } else {
        echo "Kayıt eklenirken hata oluştu: " . $insert_stmt->error;
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Çalışma Planı Ekle</title>
</head>
<body>
    <h1>Çalışma Planı Ekle</h1>
    <form method="POST">
        <label for="konum_id">Konum:</label>
        <select name="konum_id" required>
            <option value="">Seçiniz</option>
            <?php while ($konum_stmt->fetch()): ?>
                <option value="<?= $konum_id; ?>"><?= htmlspecialchars($konum_ad); ?></option>
            <?php endwhile; ?>
        </select><br>

        <label for="etiket_id">Etiket (Zorunlu Değil):</label>
        <select name="etiket_id">
            <option value="">Seçiniz</option>
            <?php while ($etiket_stmt->fetch()): ?>
                <option value="<?= $etiket_id; ?>"><?= htmlspecialchars($etiket_adi); ?></option>
            <?php endwhile; ?>
        </select><br>

        <label for="baslangic_saat">Başlangıç Saati:</label>
        <input type="time" name="baslangic_saat" required><br>

        <label for="cikis_saat">Çıkış Saati:</label>
        <input type="time" name="cikis_saat" required><br>

        <button type="submit">Kaydet</button>
    </form>
</body>
</html>
