<?php include 'db.php'; ?>

<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $urun_adi = $_POST['urun_adi'];
    $alis_fiyati = $_POST['alis_fiyati'];
    $satis_fiyati = $_POST['satis_fiyati'];
    
    $gorsel_ad = null;

    if (isset($_FILES['gorsel']) && $_FILES['gorsel']['error'] == 0) {
        $gorsel_ad = "uploads/" . basename($_FILES["gorsel"]["name"]);
        move_uploaded_file($_FILES["gorsel"]["tmp_name"], $gorsel_ad);
    }

    $stmt = $conn->prepare("INSERT INTO urunler (urun_adi, gorsel, alis_fiyati, satis_fiyati) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssdd", $urun_adi, $gorsel_ad, $alis_fiyati, $satis_fiyati);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        echo "<p class='basarili'>Ürün başarıyla eklendi!</p>";
    } else {
        echo "<p class='hata'>Ürün eklenirken hata oluştu!</p>";
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Ürün Ekle</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="form-container">
        <h2>Ürün Ekle</h2>
        <form method="POST" enctype="multipart/form-data">
            <label>Ürün Adı:</label>
            <input type="text" name="urun_adi" required>

            <label>Görsel:</label>
            <input type="file" name="gorsel" accept="image/*">

            <label>Alış Fiyatı:</label>
            <input type="number" step="0.01" name="alis_fiyati" required>

            <label>Satış Fiyatı:</label>
            <input type="number" step="0.01" name="satis_fiyati" required>

            <button type="submit">Ürünü Kaydet</button>
        </form>
    </div>
</body>
</html>
