<?php
include 'db.php'; // veritabanı bağlantısı ($conn ile)

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $yeni_oran = floatval($_POST['oran']);

    // 1. ayarlar tablosundaki oranı güncelle
    $stmt = $conn->prepare("UPDATE ayarlar SET satis_fiyati_orani = ? WHERE id = 1");
    $stmt->bind_param("d", $yeni_oran);
    $stmt->execute();
    $stmt->close();

    // 2. moduller tablosundaki tüm verileri al
    $moduller = $conn->query("SELECT id, alis_fiyati FROM moduller");

    while ($modul = $moduller->fetch_assoc()) {
        $yeni_satis_fiyati = $modul['alis_fiyati'] * $yeni_oran;

        $guncelle = $conn->prepare("UPDATE moduller SET satis_fiyati = ? WHERE id = ?");
        $guncelle->bind_param("di", $yeni_satis_fiyati, $modul['id']);
        $guncelle->execute();
        $guncelle->close();
    }

    $moduller->close();
    $basari = "Oran başarıyla güncellendi ve satış fiyatları tekrar hesaplandı.";
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Satış Fiyatı Oranı Güncelle</title>
    <style>
        body {
            font-family: Arial;
            background: #f2f9ff;
            padding: 30px;
        }
        form {
            background: white;
            padding: 20px;
            width: 400px;
            border: 1px solid #ccc;
            border-radius: 12px;
            box-shadow: 0 0 12px rgba(0,0,0,0.1);
        }
        input[type="number"] {
            width: 100%;
            padding: 10px;
            font-size: 18px;
            margin-bottom: 15px;
        }
        input[type="submit"] {
            padding: 10px 20px;
            font-size: 18px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
        }
        .success {
            background: #d4edda;
            padding: 15px;
            border-left: 5px solid #28a745;
            margin-bottom: 20px;
            color: #155724;
        }
    </style>
</head>
<body>

    <h2>Satış Fiyatı Oranı Güncelle</h2>

    <?php if (isset($basari)): ?>
        <div class="success"><?= $basari ?></div>
    <?php endif; ?>

    <form method="POST">
        <label>Yeni Oran (örn: 1.7):</label>
        <input type="number" step="0.01" name="oran" required>
        <input type="submit" value="Güncelle ve Uygula">
    </form>

</body>
</html>
