<?php
include('db.php');

$product_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$sql = "SELECT * FROM urunler WHERE id = $product_id";
$result = $conn->query($sql);
$product = $result->fetch_assoc();

$modulSorgu = "SELECT * FROM moduller WHERE urun_id = $product_id";
$modulSonuc = $conn->query($modulSorgu);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($product['urun_adi']) ?> - Detay</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

   

<style>

    @media (max-width: 768px) {
        .sticky-top-mobile {
            position: sticky !important;
            top: 0;
            z-index: 1030;
        }
       
        .container{
            padding:0;
            margin:0;
            
        }
        
        .card-header{
            padding:0;
            margin:0;
            
        }
        
        
        h3 {
            font-size: 1.3rem;
            text-align: center;
        }

        h5 {
            font-size: 1.25rem;
            text-align: center;
        }

        h6 {
            font-size: 1.1rem;
        }

        .card-body,
        .card-header,
        .card-footer {
            padding: 1.5rem;
        }

        .input-group .form-control,
        .input-group .btn,
        input.form-control,
        button.btn {
            font-size: 1.1rem !important;
            padding: 0.75rem 1rem;
        }

        #seciliModuller {
            font-size: 1.05rem;
        }

        .btn-sm {
            font-size: 1rem !important;
        }
    }

</style>
</head>
<body>

<div class="container ">
    <div class="card ">
        <div class="card-header bg-dark text-white d-flex align-items-center justify-content-between sticky-top-mobile" style="border-radius: 0;">
            <div class="me-auto">
                <a href="product_list.php"><i class="fa fa-chevron-left" aria-hidden="true" style="color:white;"></i></a>
            </div>
            <div class="flex-grow-1 text-center">
                <h3 class="mb-0"><?= htmlspecialchars($product['urun_adi']) ?></h3>
            </div>
            <div class="invisible me-auto">
                <i class="fa fa-chevron-left" aria-hidden="true"></i>
            </div>
        </div>

        <div class="card-body">
            <div class="row g-4">
                <!-- Sol Kısım: Modül Seçimi -->
                <div class="col-12 col-lg-7">
                    <h5 class="text-primary mb-3">Modül Seçimi</h5>
                    <?php while($modul = $modulSonuc->fetch_assoc()): ?>
                        <div class="border-bottom pb-3 mb-4">
                            <h6 class="fw-semibold"><?= htmlspecialchars($modul['modul_adi']) ?></h6>
                            <div class="input-group mb-2 w-100">
                                <input type="number" id="adet_<?= $modul['id'] ?>" class="form-control" placeholder="Adet" min="1">
                                <button class="btn btn-success" onclick="modulEkle(<?= $modul['id'] ?>, '<?= htmlspecialchars($modul['gorsel']) ?>', <?= $modul['satis_fiyati'] ?>, <?= $modul['alis_fiyati'] ?>, '<?= htmlspecialchars($modul['modul_adi']) ?>')">Ekle</button>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <!-- Sağ Kısım: Seçilen Modüller ve İndirim -->
                <div class="col-12 col-lg-5">
                    <h5 class="text-info mb-3">Seçilen Modüller</h5>
                    <div id="seciliModuller" class="p-3 mb-4 bg-light rounded shadow-sm text-center" style="min-height: 100px;">
                        Henüz modül seçilmedi.
                    </div>

                    <h6 class="text-warning">İndirim Uygula</h6>
                    <div class="mb-3">
                        <input type="number" id="modulYuzdeIndirim" class="form-control mb-2" placeholder="% Yüzdelik İndirim">
                        <button class="btn btn-outline-primary w-100 mb-3" onclick="modulYuzdeIndirimUygula()">Yüzdelik İndirim Uygula</button>
                    </div>

                    <div class="mb-3">
                        <input type="number" id="modulTlIndirim" class="form-control mb-2" placeholder="₺ TL İndirim">
                        <button class="btn btn-outline-primary w-100 mb-3" onclick="modulTlIndirimUygula()">TL İndirim Uygula</button>
                    </div>

                    <div id="modulIndirimSonuc" class="fw-bold text-dark mt-2 text-center"></div>
                </div>
            </div>
        </div>

       
    </div>
</div>

<script>
    const secilenler = {};
    let uygulananIndirimTutar = 0;

    function modulEkle(id, gorsel, fiyat, alisFiyati, modulAdi) {
        const adetInput = document.getElementById('adet_' + id);
        const adet = parseInt(adetInput.value);
        if (!adet || adet <= 0) {
            alert("Lütfen geçerli bir adet giriniz.");
            return;
        }

        if (secilenler[id]) {
            secilenler[id].adet += adet;
        } else {
            secilenler[id] = {
                gorsel: gorsel,
                fiyat: fiyat,
                alisFiyati: alisFiyati,
                adet: adet,
                modulAdi: modulAdi
            };
        }

        adetInput.value = '';
        uygulananIndirimTutar = 0; // Yeni modül eklenince indirimi sıfırla
        renderSecilenler();
    }

    function renderSecilenler() {
        const container = document.getElementById('seciliModuller');
        container.innerHTML = '';

        let toplamTutar = 0;
        let toplamAlisFiyati = 0;

        for (let id in secilenler) {
            const modul = secilenler[id];
            const urunToplam = modul.fiyat * modul.adet;
            const alisToplam = modul.alisFiyati * modul.adet;
            toplamTutar += urunToplam;
            toplamAlisFiyati += alisToplam;

            const div = document.createElement('div');
            div.classList.add('secilen-modul');
            div.innerHTML = 
                `<h4>${modul.modulAdi}</h4>
                <p><strong>Fiyat:</strong> ${modul.fiyat.toFixed(2)} ₺ x ${modul.adet} = <strong>${urunToplam.toFixed(2)} ₺</strong></p>`;
            container.appendChild(div);
        }

        if (toplamTutar === 0) {
            container.innerText = 'Henüz modül seçilmedi.';
        } else {
            const toplamDiv = document.createElement('div');
            toplamDiv.style.marginTop = '15px';
            toplamDiv.innerHTML = `<strong>Toplam Tutar: ${toplamTutar.toFixed(2)} ₺</strong>`;
            container.appendChild(toplamDiv);

            let karMarji = Math.round(toplamTutar - toplamAlisFiyati - uygulananIndirimTutar); // Yuvarlama işlemi
            const karMarjiDiv = document.createElement('div');
            karMarjiDiv.style.marginTop = '15px';

            // Toplam alış fiyatının 1.1 ile çarpılması
            const toplamAlisFiyatiCarpim = Math.round(toplamAlisFiyati * 1.1); // Tam sayı olarak al

            if (karMarji < 0) {
                karMarjiDiv.innerHTML = `<strong>İşlem Kodu: HATA</strong>`;
            } else {
                karMarjiDiv.innerHTML = `<strong>İşlem Kodu: LORA${karMarji}-GTXGY-${toplamAlisFiyatiCarpim}-FUAR</strong>`;
            }

            container.appendChild(karMarjiDiv);
        }
    }

    function modulYuzdeIndirimUygula() {
        const yuzde = parseFloat(document.getElementById("modulYuzdeIndirim").value);
        const sonucAlani = document.getElementById("modulIndirimSonuc");

        let toplam = 0;
        for (let id in secilenler) {
            toplam += secilenler[id].fiyat * secilenler[id].adet;
        }

        if (isNaN(yuzde) || yuzde < 0) {
            sonucAlani.innerText = "Lütfen geçerli bir yüzde giriniz.";
            return;
        }

        const indirimTutar = toplam * (yuzde / 100);
        uygulananIndirimTutar = indirimTutar;
        const yeniFiyat = toplam - indirimTutar;

        sonucAlani.innerHTML = 
            `Uygulanan İndirim: %${yuzde.toFixed(2)}<br>
            İndirim Tutarı: ${indirimTutar.toFixed(2)} ₺<br>
            İndirimli Satış Fiyatı: ${yeniFiyat.toFixed(2)} ₺`;

        renderSecilenler();
    }

    function modulTlIndirimUygula() {
        const tl = parseFloat(document.getElementById("modulTlIndirim").value);
        const sonucAlani = document.getElementById("modulIndirimSonuc");

        let toplam = 0;
        for (let id in secilenler) {
            toplam += secilenler[id].fiyat * secilenler[id].adet;
        }

        if (isNaN(tl) || tl < 0 || tl > toplam) {
            sonucAlani.innerText = "Lütfen geçerli bir TL tutarı giriniz.";
            return;
        }

        uygulananIndirimTutar = tl;
        const yuzde = (tl / toplam) * 100;
        const yeniFiyat = toplam - tl;

        sonucAlani.innerHTML = 
            `Uygulanan İndirim: %${yuzde.toFixed(2)}<br>
            İndirim Tutarı: ${tl.toFixed(2)} ₺<br>
            İndirimli Satış Fiyatı: ${yeniFiyat.toFixed(2)} ₺`;

        renderSecilenler();
    }
</script>




</body>
</html>

<?php $conn->close(); ?>
