<?php
include 'db.php';

if (!isset($_GET['urun_id'])) {
    die("Ürün ID belirtilmedi.");
}

$urun_id = (int)$_GET['urun_id'];

// Ürün adı
$urun_sorgu = $conn->prepare("SELECT urun_adi FROM urunler WHERE id = ?");
$urun_sorgu->bind_param("i", $urun_id);
$urun_sorgu->execute();
$urun_sorgu->bind_result($urun_adi);
$urun_sorgu->fetch();
$urun_sorgu->close();

// Modüller
$modul_sorgu = $conn->prepare("SELECT * FROM moduller WHERE urun_id = ?");
$modul_sorgu->bind_param("i", $urun_id);
$modul_sorgu->execute();
$moduller = $modul_sorgu->get_result();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Modüller - <?php echo htmlspecialchars($urun_adi); ?></title>
</head>
<body>
    <h2><?php echo htmlspecialchars($urun_adi); ?> - Modüller</h2>
    <table border="1" cellpadding="8" cellspacing="0">
        <tr>
            <th>Modül Adı</th>
            <th>Alış Fiyatı</th>
            <th>Güncelle</th>
        </tr>
        <?php while ($modul = $moduller->fetch_assoc()) { ?>
            <tr>
                <td><?php echo htmlspecialchars($modul['modul_adi']); ?></td>
                <td>
                    <form action="guncelle_fiyat.php" method="post" style="display: inline;">
                        <input type="hidden" name="modul_id" value="<?php echo $modul['id']; ?>">
                        <input type="text" name="alis_fiyati" value="<?php echo $modul['alis_fiyati']; ?>" size="8">
                        <button type="submit">Kaydet</button>
                    </form>
                </td>
                <td><img src="<?php echo $modul['gorsel']; ?>" width="50" alt=""></td>
            </tr>
        <?php } ?>
    </table>

    <br><a href="urunler.php">← Geri dön</a>
</body>
</html>
